	function [s11, s21] = CT_TREE_WDF_LP_H(alfa, wT)
	
	% 	Computes the frequency response of an odd order lowpass
	%	circulator-tree wave digital filter consisting of 
	%	three- and four-port adaptors. The first coefficient
	%	is the first-order section.  
	
	% 	If the order N is 3, 7, 11, 15,.. the second section from 	
	%	the left has 1 inverters at thier input, a2, and output, b2.
	
	% 	If the order N is 5, 9, 13, 17,.. the thired section from 
	%	the left has 1 inverters at thier input, a2, and output, b2.
	
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 			Lars Wanhammar 2009-11-15
	% 	Modified by: 	 	LW 2011-07-04, 2014-08-23, 2019-03-29
	% 	Copyright:			by authors - not released for commercial use
	% 	Version:			1 
	% 	Known bugs:		
	% 	Report bugs to:		Wanhammar@gmail.com
	
	% check filter order
 	N = 2*length(alfa(:,1))-1;
	
	ewT = exp(-i*wT);
	ewT2 = exp(-i*wT*2);	
	Denom = ewT + 2*alfa(1,1) - 1;
	s11 = (alfa(1,1)-1)*(1-ewT)./Denom;
	s22 = s11;
	s21 = alfa(1,1)*(ewT + 1)./Denom;
	s12 = s21;
	sig = 1;
	if mod((N-1)/2, 2) == 0, 
		sig = -1; 
	end % Sign of the sections	
	if N == 5
		sig = 1;
	end
	for k = 2:length(alfa(:,1))
		b = 2*(alfa(k,1)+alfa(k,3)-1);
		Denom = ewT2 + b*ewT + 1 - 2*alfa(k,1);
		s211 = ((1-alfa(k,1))*ewT2 + b*ewT + 1 - alfa(k,1))./Denom;
		s222 = s211;
		s221 = (sig*alfa(k,1)*(1-ewT2))./Denom;
		s212 = s221;
		A = s212.*s21+s211.*s11;
		s21 = s222.*s21+s221.*s11;
		s11 = A;
		B = s212.*s22+s211.*s12;	
		s22 = s222.*s22+s221.*s12;
		s12 = B;
		%	disp(['S', num2str(k),' sign = ', num2str(sig)])
		sig = -sig;
	end

	
